/*

Test program for sending measured values from the
Raspberry PI over Modbus TCP to the web server

Sending is done with HTTP POST

Josef Bernhardt 13.2.2021


Hardware Raspberry PI 4

Codeblocks fuer Raspbian

Example Message

POST /heizung/sqlabfrage.php HTTP/1.0
Host: www.bernhardt.de
Connection: close
Content-Type: application/x-www-form-urlencoded;charset=UTF-8;
Content-Length: 44

aktion=write&file=inputs.csv&inhalt=23.00;1;0;1;0;1;0;1;1

*/
#include <stdio.h>      /* printf, sprintf */
#include <stdlib.h>     /* exit */
#include <unistd.h>     /* read, write, close */
#include <string.h>     /* memcpy, memset */
#include <sys/socket.h> /* socket, connect */
#include <netinet/in.h> /* struct sockaddr_in, struct sockaddr */
#include <netdb.h>      /* struct hostent, gethostbyname */

#define FC1 1
#define FC2 2


void error(const char *msg) { perror(msg); /*exit(0);}*/ }

// String for Result from Modbus Call FC01
char strresult[16] = {'0',';','0',';','0',';','0',';','0',';','0',';','0',';','0',0};

// Post Message to HTTP Server
char *msg_post = "POST /modbus/sqlabfrage.php HTTP/1.0\r\n";
char *msg_host = "Host: www.bernhardt.de\r\n";
char *msg_conn = "Connection: close\r\n";
char *msg_cont = "Content-Type: application/x-www-form-urlencoded;charset=UTF-8;\r\n";
char *msg_conl = "Content-Length: %d\r\n\r\n";

char *msg_acti_fc1 = "aktion=write&file=outputs.csv&inhalt=%.2f;";
char *msg_acti_fc2 = "aktion=write&file=inputs.csv&inhalt=%.2f;";
// mit Content length
char msg_conl_r[128]={0};
// mit Zahlenwert
char msg_acti_r[128]={0};

char msg_send[512]={0};

//char message[1024];
char response[1024];

// Data from Modbus
char usr_response[128]={0};

// build Poststring with Modbus Data and float Value
void build_post_string_fc1(float value, char *str)
{
    // Clear Post message memory
    memset(&msg_send,0,512);
    // Insert float Value
    sprintf(msg_acti_r,msg_acti_fc1,value);

    // Calculate and insert the length of the action string
    sprintf(msg_conl_r,"Content-Length: %d\r\n\r\n",strlen(msg_acti_fc1)+15);
    // Build Post String
    strcat(msg_send,msg_post);
    strcat(msg_send,msg_host);
    strcat(msg_send,msg_conn);
    strcat(msg_send,msg_cont);
    strcat(msg_send,msg_conl_r);
    strcat(msg_send,msg_acti_r);
    strcat(msg_send,str);
}

// build Poststring with Modbus Data and float Value
void build_post_string_fc2(float value, char *str)
{
    // Clear Post message memory
    memset(&msg_send,0,512);
    // Insert float Value
    sprintf(msg_acti_r,msg_acti_fc2,value);

    // Calculate and insert the length of the action string
    sprintf(msg_conl_r,"Content-Length: %d\r\n\r\n",strlen(msg_acti_fc2)+15);
    // Build Post String
    strcat(msg_send,msg_post);
    strcat(msg_send,msg_host);
    strcat(msg_send,msg_conn);
    strcat(msg_send,msg_cont);
    strcat(msg_send,msg_conl_r);
    strcat(msg_send,msg_acti_r);
    strcat(msg_send,str);
}


// Send Post Message to Server
void sendpostmsg()
{

    int portno =        80;
    char *host =        "www.bernhardt.de";

    struct hostent *server;
    struct sockaddr_in serv_addr;
    int sockfd, bytes, sent, received, total;

    /* create the socket */
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) error("ERROR opening socket");

    /* lookup the ip address */
    server = gethostbyname(host);
    if (server == NULL) error("ERROR, no such host");

    /* fill in the structure */
    memset(&serv_addr,0,sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(portno);
    memcpy(&serv_addr.sin_addr.s_addr,server->h_addr,server->h_length);

    /* connect the socket */
    if (connect(sockfd,(struct sockaddr *)&serv_addr,sizeof(serv_addr)) < 0)
        error("ERROR connecting");
        /* send the request */
        total = strlen(msg_send);
        sent = 0;

        bytes = write(sockfd,msg_send+sent,total-sent);
 /*
        do {
            bytes = write(sockfd,msg_send+sent,total-sent);
            if (bytes < 0)
                error("ERROR writing message to socket");
            if (bytes == 0)
                break;
            sent+=bytes;
        } while (sent < total);
*/
        sleep(0.020);

        /* receive the response */
        memset(response,0,sizeof(response));
        total = sizeof(response)-1;
        received = 0;

        // Read Answer from HTTP Webserver
        bytes = read(sockfd,response,total);
/*
        do {
            bytes = read(sockfd,response+received,total-received);
            if (bytes < 0)
                error("ERROR reading response from socket");
            if (bytes == 0)
                break;
            received+=bytes;
        } while (received < total);

        if (received == total)
        error("ERROR storing complete response from socket");
 */

    /* close the socket */
    close(sockfd);
}


// Read Data from raspberry PI PLC
void sendtcpip_modbusFC1()
{

    unsigned char obuf[128];
    unsigned char ibuf[128];

    unsigned short reg_no = 0;
    unsigned short num_regs = 8;
    unsigned short unit = 1;
    unsigned short transid = 1;
    unsigned short slaveadr =1;

    int portno =        502;

    // test with second Raspberry PI
    // char *host =        "192.168.178.89";
    // local adress
    char *host =        "127.0.0.1";

    struct hostent *server;
    struct sockaddr_in serv_addr;
    int sockfd, bytes, sent, received, total,i;

    unsigned char mask = 0x01;
    unsigned char result = 0x09;

    obuf[0] = (unsigned char)transid >>8;
    obuf[1] = (unsigned char)transid;
    obuf[2] = 0;
    obuf[3] = 0;
    obuf[4] = 0;
    obuf[5] = 6;             // Message Length Low(6 bytes to follow)
    obuf[6] = slaveadr;             // SlaveAdress
    obuf[7] = FC1;                    // Function
    obuf[8] = reg_no >> 8;          // Starting Address High
    obuf[9] = reg_no & 0xff;        // Starting Address Low
    obuf[10] = num_regs >> 8;       // Quantity of Coils High
    obuf[11] = num_regs & 0xff;     // Quantity of Coils Low

    /* create the socket */
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) error("ERROR opening socket");

    /* lookup the ip address */
    server = gethostbyname(host);
    if (server == NULL) error("ERROR, no such host");

    /* fill in the structure */
    memset(&serv_addr,0,sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(portno);
    memcpy(&serv_addr.sin_addr.s_addr,server->h_addr,server->h_length);

    /* connect the socket */
    if (connect(sockfd,(struct sockaddr *)&serv_addr,sizeof(serv_addr)) < 0)
        error("ERROR connecting");
        /* send the request */
        total = 12;

        bytes = write(sockfd,obuf,total);
        if (bytes < 0) error("ERROR writing message to socket");

/*
        printf("TCP-Send..\r\n");
        for (i=0;i<bytes;i++)
        {
          printf(" %02x ",obuf[i]);
        }
        printf("\r\n");
*/
        sleep (0.05) ;

        bytes = read(sockfd,ibuf,128);
        //printf("Bytes: %d\r\n",bytes);
        //printf("TCP-Received..\r\n");

        for (i=0;i<bytes;i++)
        {
          //printf(" %02x ",ibuf[i]);
        }
/*
        if ( ibuf[result] & mask ) printf("1;"); else printf("0;");mask = mask << 1;
        if ( ibuf[result] & mask ) printf("1;"); else printf("0;");mask = mask << 1;
        if ( ibuf[result] & mask ) printf("1;"); else printf("0;");mask = mask << 1;
        if ( ibuf[result] & mask ) printf("1;"); else printf("0;");mask = mask << 1;
        if ( ibuf[result] & mask ) printf("1;"); else printf("0;");mask = mask << 1;
        if ( ibuf[result] & mask ) printf("1;"); else printf("0;");mask = mask << 1;
        if ( ibuf[result] & mask ) printf("1;"); else printf("0;");mask = mask << 1;
        if ( ibuf[result] & mask ) printf("1"); else printf("0");
*/

        if ( ibuf[result] & mask ) strresult[0] = '1'; else strresult[0] = '0'; mask = mask << 1;
        if ( ibuf[result] & mask ) strresult[2] = '1'; else strresult[2] = '0'; mask = mask << 1;
        if ( ibuf[result] & mask ) strresult[4] = '1'; else strresult[4] = '0'; mask = mask << 1;
        if ( ibuf[result] & mask ) strresult[6] = '1'; else strresult[6] = '0'; mask = mask << 1;
        if ( ibuf[result] & mask ) strresult[8] = '1'; else strresult[8] = '0'; mask = mask << 1;
        if ( ibuf[result] & mask ) strresult[10] = '1'; else strresult[10] = '0'; mask = mask << 1;
        if ( ibuf[result] & mask ) strresult[12] = '1'; else strresult[12] = '0'; mask = mask << 1;
        if ( ibuf[result] & mask ) strresult[14] = '1'; else strresult[14] = '0';


        //printf("%s\r\n",strresult);
        /* close the socket */
        close(sockfd);
}


// Read Data from raspberry PI PLC Input Pins %IX0.0 to %IX0.7
void sendtcpip_modbusFC2()
{

    unsigned char obuf[128];
    unsigned char ibuf[128];

    unsigned short reg_no = 0;
    unsigned short num_regs = 8;
    unsigned short unit = 1;
    unsigned short transid = 1;
    unsigned short slaveadr =1;

    int portno =        502;

    // test with second Raspberry PI
    // char *host =        "192.168.178.89";
    // local adress
    char *host =        "127.0.0.1";

    struct hostent *server;
    struct sockaddr_in serv_addr;
    int sockfd, bytes, sent, received, total,i;

    unsigned char mask = 0x01;
    unsigned char result = 0x09;

    obuf[0] = (unsigned char)transid >>8;
    obuf[1] = (unsigned char)transid;
    obuf[2] = 0;
    obuf[3] = 0;
    obuf[4] = 0;
    obuf[5] = 6;             // Message Length Low(6 bytes to follow)
    obuf[6] = slaveadr;             // SlaveAdress
    obuf[7] = FC2;                    // Function
    obuf[8] = reg_no >> 8;          // Starting Address High
    obuf[9] = reg_no & 0xff;        // Starting Address Low
    obuf[10] = num_regs >> 8;       // Quantity of Coils High
    obuf[11] = num_regs & 0xff;     // Quantity of Coils Low

    /* create the socket */
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) error("ERROR opening socket");

    /* lookup the ip address */
    server = gethostbyname(host);
    if (server == NULL) error("ERROR, no such host");

    /* fill in the structure */
    memset(&serv_addr,0,sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(portno);
    memcpy(&serv_addr.sin_addr.s_addr,server->h_addr,server->h_length);

    /* connect the socket */
    if (connect(sockfd,(struct sockaddr *)&serv_addr,sizeof(serv_addr)) < 0)
        error("ERROR connecting");
        /* send the request */
        total = 12;

        bytes = write(sockfd,obuf,total);
        if (bytes < 0) error("ERROR writing message to socket");

/*
        printf("TCP-Send..\r\n");
        for (i=0;i<bytes;i++)
        {
          printf(" %02x ",obuf[i]);
        }
        printf("\r\n");
*/
        sleep (0.05) ;

        bytes = read(sockfd,ibuf,128);
        //printf("Bytes: %d\r\n",bytes);
        //printf("TCP-Received..\r\n");

        for (i=0;i<bytes;i++)
        {
          //printf(" %02x ",ibuf[i]);
        }
/*
        if ( ibuf[result] & mask ) printf("1;"); else printf("0;");mask = mask << 1;
        if ( ibuf[result] & mask ) printf("1;"); else printf("0;");mask = mask << 1;
        if ( ibuf[result] & mask ) printf("1;"); else printf("0;");mask = mask << 1;
        if ( ibuf[result] & mask ) printf("1;"); else printf("0;");mask = mask << 1;
        if ( ibuf[result] & mask ) printf("1;"); else printf("0;");mask = mask << 1;
        if ( ibuf[result] & mask ) printf("1;"); else printf("0;");mask = mask << 1;
        if ( ibuf[result] & mask ) printf("1;"); else printf("0;");mask = mask << 1;
        if ( ibuf[result] & mask ) printf("1"); else printf("0");
*/

        if ( ibuf[result] & mask ) strresult[0] = '1'; else strresult[0] = '0'; mask = mask << 1;
        if ( ibuf[result] & mask ) strresult[2] = '1'; else strresult[2] = '0'; mask = mask << 1;
        if ( ibuf[result] & mask ) strresult[4] = '1'; else strresult[4] = '0'; mask = mask << 1;
        if ( ibuf[result] & mask ) strresult[6] = '1'; else strresult[6] = '0'; mask = mask << 1;
        if ( ibuf[result] & mask ) strresult[8] = '1'; else strresult[8] = '0'; mask = mask << 1;
        if ( ibuf[result] & mask ) strresult[10] = '1'; else strresult[10] = '0'; mask = mask << 1;
        if ( ibuf[result] & mask ) strresult[12] = '1'; else strresult[12] = '0'; mask = mask << 1;
        if ( ibuf[result] & mask ) strresult[14] = '1'; else strresult[14] = '0';


        //printf("%s\r\n",strresult);
        /* close the socket */
        close(sockfd);
}

// function to replace , with . or others
int replacechar(char *str, char orig, char rep) {
    char *ix = str;
    int n = 0;
    while((ix = strchr(ix, orig)) != NULL) {
        *ix++ = rep;
        n++;
    }
    return n;
}


// main function
int main(int argc,char *argv[])
{

    printf("Testsoftware to Read Modbus Data %QX0.0 to QX0.7\r\n");
    printf("from Raspberry PI openplcproject PLC\r\n");
    printf("\r\n");
    printf("Send Data to HTTP Server www.bernhardt.de \r\n");
    printf("to php Server directory /modbus/sqlabfrage.php \r\n");
    printf("\r\n");

    float x1 = 0.0;
    float x2 = 5.0;

    while(1)
    {
        // Teststring when no Modbus Data available
        // build_post_string("1.34;1;0;1;0;1;0;1;0");

        x1=x1+0.1;
        x2=x2+0.1;

        if (x1 > 4.9) x1 = 0;
        if (x2 > 9.9) x2 = 5;

        // Read Data from Modbus
        sendtcpip_modbusFC1();
        // Generate Poststring
        build_post_string_fc1(x1,strresult);
        // Send Data to Webservers PHP Software
        sendpostmsg();

        // printf(msg_send);printf("\r\n");

        printf(strresult);printf("  ");
        // Wait
        sleep(0.5);

         // Read Data from Modbus
        sendtcpip_modbusFC2();
        // Generate Poststring
        build_post_string_fc2(x2,strresult);
        // Send Data to Webservers PHP Software
        sendpostmsg();
        // printf(msg_send);

        sleep(0.5);
        // Answer from Webserver
        // printf(response);

        // Reasponse from Modbus
        printf(strresult);

        // Send Post Message to Terminal Windows
        // printf(msg_send);
        printf("\r\n");



    }
    return 0;
}
